Scriptname nwsFollower_PlayerAlias extends ReferenceAlias  

nwsFollowerControllerScript Property controlScript Auto
GlobalVariable Property PlayerFollowerCount  Auto  
GlobalVariable Property PlayerAnimalCount  Auto  
GlobalVariable Property nwsFollowerCount Auto
GlobalVariable Property nwsAnimalCount Auto
Float CheckTime = 8.0
Faction Property DismissedFollower Auto
Faction Property CurrentHireling Auto
Weapon Property FollowerHuntingBow Auto
Ammo Property FollowerIronArrow Auto

GlobalVariable Property nwsRealCount Auto
GlobalVariable Property nwsAllowSpeed Auto ; speed boost moved to main script
GlobalVariable Property nwsImportCount Auto ; number of imported allies
Faction Property CurrentFollowerFaction Auto
Faction Property PlayerFollowerFaction Auto
Faction Property WIFollowerCommentFaction Auto
Quest Property nwsFollowerPack Auto
Faction Property nwsFF_ImportFac Auto

Float Property nwsFF_version Auto

Quest Property DialogueFollower Auto

Event OnInit()
	CheckVersion(1)
EndEvent

Event OnPlayerLoadGame()
	CheckVersion(0)
EndEvent

Event OnUpdate()
	CheckCount()
EndEvent

Event OnLocationChange(Location akOldLoc, Location akNewLoc)
	; follower count/sandbox adjust
	Utility.Wait(0.2)
	RegisterForSingleUpdate(CheckTime)
EndEvent

Function CheckVersion(int myVal)
	Float nwsFF_currVersion = 1.2
	if nwsFF_version != nwsFF_currVersion
		float roundVal = Math.floor(nwsFF_currVersion * 100 + 0.5) / 100.0
		int wholeVal = Math.floor(roundVal)
		int decVal = Math.floor((roundVal - wholeVal) * 100 + 0.5)

		if myVal == 1
			CleanFollowerQuest()
			Debug.Notification("Follower Framework Version "+ wholeVal+"."+decVal + " Installed")
		else
			Debug.Notification("Follower Framework Updated to Version "+ wholeVal+"."+decVal )
		endif

		nwsFF_version = nwsFF_currVersion
	endif

	if nwsRealCount.GetValue() == 1
		RegisterForSingleUpdate(CheckTime)
	endif

	; Do Startup Check
	controlScript.StartupCheck()

	; apply speed boost

EndFunction

Function CheckCount()

	if ((PlayerFollowerCount.GetValue() == 1) && (nwsFollowerCount.GetValue() < 5)) || ((PlayerAnimalCount.GetValue() == 1) && (nwsAnimalCount.GetValue() < 5)) || (nwsImportCount.GetValue() > 0)
		;debug.notification("Adjusting Follower Count")
		controlScript.GetFollowerCount()
	endif

	if nwsRealCount.GetValue() == 1
		RegisterForSingleUpdate(CheckTime)
	endif
EndFunction

; maintenance function
Function CleanFollowerQuest()
	debug.notification("Restarting Follower Quest")

	; clean aliases
	int count = 25
	int index = 0
	bool stopLook = False
	actor follower
	ReferenceAlias followerAlias
	ReferenceAlias packAlias

	while !stopLook
		followerAlias = DialogueFollower.GetAlias(index) as ReferenceAlias
		if followerAlias != None
			;debug.notification("clearing alias "+index)
			follower = followerAlias.GetReference() as actor
			if follower
				;debug.notification("clearing follower")
				if follower.IsInFaction(DismissedFollower)
					follower.RemoveFromFaction(DismissedFollower)
				endif
				if follower.IsInFaction(CurrentHireling)
					follower.RemoveFromFaction(CurrentHireling)
				endif
				follower.StopCombatAlarm()
				follower.SetPlayerTeammate(False)
				follower.SetAV("WaitingForPlayer", 0)
				follower.RemoveItem(FollowerHuntingBow, 999, true)
				follower.RemoveItem(FollowerIronArrow, 999, true)

				if follower.IsInFaction(nwsFF_ImportFac)
					follower.RemoveFromFaction(nwsFF_ImportFac)
					packAlias = nwsFollowerPack.GetAlias(index) as ReferenceAlias
					if packAlias
						packAlias.Clear()
					endif
				else
					follower.RemoveFromFaction(CurrentFollowerFaction)
					follower.RemoveFromFaction(PlayerFollowerFaction)
					follower.RemoveFromFaction(WIFollowerCommentFaction)
				endif
			endif
			followerAlias.Clear()
		endif
		index += 1
		stopLook = (index >= count)
	endwhile

	nwsImportCount.SetValue(0)
	PlayerFollowerCount.SetValue(0)
	PlayerAnimalCount.SetValue(0)
	Utility.Wait(0.5)

	DialogueFollower.Stop()
	Utility.Wait(0.5)
	DialogueFollower.Start()
	Utility.Wait(0.5)
	DialogueFollower.Reset()
	Utility.Wait(0.5)
	debug.notification("Follower Framework Ready")

EndFunction
